/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWInvokeParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWInvokeFaultsPanel
extends JPanel {
    private static final int COL_NAME = 0;
    private static final int COL_XML_DATA_FIELD = 1;
    private static final int COL_SUBMAP = 2;
    private VWInvokeParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_XMLDataField = null;
    private JTextField m_submap = null;
    private String[] m_faultsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_xmlDataField, VWResource.s_submap};
    private VWTable m_faultsParamsTable = null;
    private AbstractTableModel m_faultsParamsTableModel = null;
    private VWFaultDefinition[] m_faultsParams = null;

    public VWInvokeFaultsPanel(VWInvokeParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        VWToolbarBorder faultsParamsBorder = new VWToolbarBorder(VWResource.s_specificFaults, 0);
        JPanel faultsParamsPanel = faultsParamsBorder.getClientPanel();
        faultsParamsPanel.setLayout(new BorderLayout());
        faultsParamsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_faultsParamsTable = new VWTable();
        this.m_faultsParamsTable.setRowSelectionAllowed(true);
        this.m_faultsParamsTable.setColumnSelectionAllowed(false);
        this.m_faultsParamsTable.setSelectionMode(0);
        faultsParamsPanel.add((Component)new JScrollPane(this.m_faultsParamsTable), "Center");
        JLabel XMLDataFieldLabel = new JLabel(VWResource.s_xmlDataFieldColon);
        this.m_XMLDataField = new JTextField();
        this.m_XMLDataField.setEditable(false);
        this.m_XMLDataField.setBorder(null);
        JPanel XMLDataFieldPanel = new JPanel(new BorderLayout(10, 0));
        XMLDataFieldPanel.add((Component)XMLDataFieldLabel, "Before");
        XMLDataFieldPanel.add((Component)this.m_XMLDataField, "Center");
        JLabel submapLabel = new JLabel(VWResource.s_submapColon);
        this.m_submap = new JTextField();
        this.m_submap.setEditable(false);
        this.m_submap.setBorder(null);
        JPanel submapPanel = new JPanel(new BorderLayout(10, 0));
        submapPanel.add((Component)submapLabel, "Before");
        submapPanel.add((Component)this.m_submap, "Center");
        VWToolbarBorder otherFaultsParamsBorder = new VWToolbarBorder(VWResource.s_otherFaults, 0);
        JPanel otherFaultsParamsPanel = otherFaultsParamsBorder.getClientPanel();
        otherFaultsParamsPanel.setLayout(new GridBagLayout());
        otherFaultsParamsPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.gridheight = 1;
        c1.weightx = 1.0;
        c1.weighty = 0.0;
        c1.anchor = 23;
        c1.gridwidth = 0;
        otherFaultsParamsPanel.add((Component)XMLDataFieldPanel, c1);
        c1.gridy = -1;
        c1.weighty = 1.0;
        otherFaultsParamsPanel.add((Component)submapPanel, c1);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)faultsParamsBorder, c);
        c.gridy = -1;
        this.add((Component)otherFaultsParamsBorder, c);
    }

    private void reinitialize() {
        try {
            this.m_faultsParamsTableModel = null;
            VWFaultDefinition fault = ((VWInvokeInstruction)this.m_instructionDef).getCatchAllFault();
            if (fault != null) {
                String XMLDataField = fault.getFaultMessage();
                this.m_parent.setTextField(this.m_XMLDataField, XMLDataField);
                String submap = fault.getFaultMapName();
                this.m_parent.setTextField(this.m_submap, submap);
            }
            this.m_faultsParams = ((VWInvokeInstruction)this.m_instructionDef).getFaults();
            if (this.m_faultsParams != null) {
                if (this.m_faultsParamsTableModel == null) {
                    this.m_faultsParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWInvokeFaultsPanel.this.m_faultsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWInvokeFaultsPanel.this.m_faultsTableColumnNames[1];
                                }
                                case 2: {
                                    return VWInvokeFaultsPanel.this.m_faultsTableColumnNames[2];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWInvokeFaultsPanel.this.m_faultsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWInvokeFaultsPanel.this.m_faultsParams != null) {
                                return VWInvokeFaultsPanel.this.m_faultsParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWInvokeFaultsPanel.this.m_faultsParams != null && nRowIndex >= 0 && nRowIndex < VWInvokeFaultsPanel.this.m_faultsParams.length) {
                                    VWFaultDefinition paramDef = VWInvokeFaultsPanel.this.m_faultsParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef.getName();
                                        }
                                        case 1: {
                                            return paramDef.getFaultMessage();
                                        }
                                        case 2: {
                                            return paramDef.getFaultMapName();
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_faultsParamsTable.setModel(this.m_faultsParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_faultsParamsTable, this.m_faultsParamsTableModel);
                this.m_faultsParamsTableModel.fireTableDataChanged();
                this.m_faultsParamsTable.fitColumnsInTable();
                this.m_faultsParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        this.m_XMLDataField = null;
        this.m_submap = null;
        for (i = 0; i < this.m_faultsTableColumnNames.length; ++i) {
            this.m_faultsTableColumnNames[i] = null;
        }
        if (this.m_faultsParams != null) {
            for (i = 0; i < this.m_faultsParams.length; ++i) {
                this.m_faultsParams[i] = null;
            }
        }
        if (this.m_faultsParamsTable != null) {
            this.m_faultsParamsTable.removeReferences();
            this.m_faultsParamsTable = null;
        }
        this.m_faultsParamsTableModel = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

